/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.trowels.upgrade;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TrowelUpgrade {
    REFILL{

        @Override
        public void afterPlace(ItemStack trowel, UseOnContext context, int selectedSlot, ItemStack placedBlock) {
            int matchingSlot;
            Inventory inv = context.m_43723_().m_150109_();
            while (placedBlock.m_41613_() < placedBlock.m_41741_() && (matchingSlot = this.findNonHotbarSlotMatchingItem(inv, placedBlock)) >= 0) {
                ItemStack item = (ItemStack)inv.f_35974_.get(matchingSlot);
                int toRefill = Math.min(item.m_41613_(), placedBlock.m_41741_() - placedBlock.m_41613_());
                item.m_41774_(toRefill);
                if (item.m_41619_()) {
                    inv.f_35974_.set(matchingSlot, (Object)ItemStack.f_41583_);
                }
                placedBlock.m_41769_(toRefill);
            }
        }

        private int findNonHotbarSlotMatchingItem(Inventory inv, ItemStack stack) {
            for (int i = Inventory.m_36059_(); i < inv.f_35974_.size(); ++i) {
                if (((ItemStack)inv.f_35974_.get(i)).m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)inv.f_35974_.get(i)))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Component getName() {
            return Component.m_237115_((String)"trowel_upgrade.refill").m_130940_(ChatFormatting.GREEN);
        }

        @Override
        public Component getDescription() {
            return Component.m_237115_((String)"trowel_upgrade.refill.desc");
        }
    };


    public void afterPlace(ItemStack trowel, UseOnContext context, int selectedSlot, ItemStack placedBlock) {
    }

    public abstract Component getName();

    public abstract Component getDescription();
}

